function Interference(varargin)

% Cette fonction permet de simuler la reconstruction, lectron par
% lectron de la figure d'interfrence donne par une bifente d'Young. 
%   Concrtement, on considre l'exprience de Faget et Fert. 
%   >>nobjetmax = Nombre d'objets physiques (ici des lectrons)  envoyer successivement
%
% Olivier Pujol (janvier 2013)

%% Vrifications diverses

if (length(varargin)>1), error('Mauvais nombre d''arguments d''entre');end
if (isempty(varargin)),nobjetmax=1000;end
if (length(varargin)==1),nobjetmax=varargin{1};end

%% Constantes

epsilon=0.5E-6;     % Largeur d'une fente (m)
a=2E-6;             % Distance entre les fentes (m)
lambdaDB=5.48E-12;  % Longueur d'onde du rayonnement (m)
d=0.35;             % Distance fente-cran (m)

%% Domaine spatial sur l'cran

x=linspace(-4E-6,4E-6,2500);    % Perpendiculaire aux fentes
y=linspace(-0.1,0.1,2);             % Parallle aux fentes

%% Intensit normalise ou probabilit d'impact

% Terme de diffraction normalis
diff=(sin(pi*epsilon.*x/(lambdaDB*d))./(pi*epsilon.*x/(lambdaDB*d))).^2; 

% Amplitude de probabilit
amplitude=(1/sqrt(2))*(sin(pi*epsilon.*x/(lambdaDB*d))./(pi*epsilon.*x/(lambdaDB*d))).*... 
    ((1+cos(2*pi*a.*x/(lambdaDB*d)))).^(0.5);
        
% Probabilit    
probabilite=amplitude.^2;

%% Partie graphique 

figure(1)
hold on

% Enlever les deux commentaires (%) pour faire un film
%film(1:nobjetmax) = struct('cdata', [],'colormap', []);
%set(gca,'nextplot','replacechildren');

% Reprsentation de l'intensit normalise
subplot(3,1,1)
plot(x*1E6,probabilite,'b',x*1E6,diff,'r:'); % Axe des x en m (commodit)
axis([min(x*1E6) max(x*1E6) 0 1]);
set(gca,'XTick',-4:1:4,'XTickLabel',{'-4','','','','0','','','','4'},...
    'YTick',[0 0.5 1],'YTickLabel',{'0','','1'},'Fontsize',16);
xlabel('{\it x} (m)','Fontsize',16);
ylabel('{\it{\rho}_p / \rho_{p,max}}','Fontsize',16);

% Graphe  deux dimensions des interfrences sur l'cran
[xx,yy]=meshgrid(x,y);  
probabilite2D=repmat(probabilite,length(y),1);
subplot(3,1,2)
pcolor(xx*1E6,yy,probabilite2D) % Axe des x en m (commodit)
axis([min(min(xx*1E6)) max(max(xx*1E6)) min(min(yy)) max(max(yy))]);
colormap(gray);shading interp
set(gca,'XTick',[-4 0 4],'XTickLabel',{'-4','0','4'},'YTick',[],'Fontsize',16);
xlabel('{\it x} (m)','Fontsize',16);

% Reconstruction de la figure prcdente lectron par lectron
subplot(3,1,3)
set(gca,'Color','k');
set(gca,'XTick',[-4 0 4],'XTickLabel',{'-4','0','4'},'YTick',[],'Fontsize',16);
axis([min(x*1E6) max(x*1E6) min(y) max(y)]);
xlabel('{\it x} (m)','Fontsize',16);
set(gcf, 'InvertHardCopy', 'off');
hold on

nobjet=1;          % Initialisation du nombre de lectrons

% Initialisation des vecteurs pour un histogramme du nombre d'impact 
nintervalle=100;   
xhist=linspace(min(x),max(x),nintervalle);
nhist=zeros(length(xhist),1);

while nobjet<=nobjetmax
    xal= min(x) + (max(x)-min(x)).*rand(1,1);   % Coordonne x alatoire
    yal= min(y) + (max(y)-min(y)).*rand(1,1);   % Coordonne y alatoire
    
    ampimp=(1/sqrt(2))*(sin(pi*epsilon*xal/(lambdaDB*d))/(pi*epsilon*xal/(lambdaDB*d)))*...
            ((1+cos(2*pi*a.*xal/(lambdaDB*d)))).^(0.5);
    probaimp=ampimp^2;
    
    nbal=rand(1,1);     % Nombre alatoire compris entre 0 et 1   
    if probaimp > nbal
        plot(xal*1E6,yal,'wo','markerfacecolor','w','markersize',3);    % Axe des x en m (commodit)
        hold on
        % On repre l'indice de xal dans le vecteur xhist puis on incrmente
        % le compteur nhist correspondant
        ixal=round(1+((xal-min(xhist))/(max(xhist)-min(xhist)))*(100-1));
        nhist(ixal)=nhist(ixal)+1;
        % On incrmente le numro de l'objet physique envoy
        nobjet=nobjet+1;    % Mettre un commentaire (%) pour faire un film
    end
    pause(0.01)
    
    % Enlever les deux commentaires (%) ci-dessous pour faire un film
    %nobjet=nobjet+1; 
    %film(nobjet-1)=getframe(gcf);  % Enlever le commentaire (%) pour faire un film
end

% Enlever le commentaire (%) pour faire un film
%movie2avi(film, 'Film-interfrence-2000-lectrons.avi','fps',24,'compression','Cinepak');

figure(2)

% Reprsentation de l'intensit normalise
subplot(2,1,1)
plot(x*1E6,probabilite,'b',x*1E6,diff,'r:'); % Axe des x en m (commodit)
axis([min(x*1E6) max(x*1E6) 0 1]);
set(gca,'XTick',-4:1:4,'XTickLabel',{'-4','','','','0','','','','4'},...
    'YTick',[0 0.5 1],'YTickLabel',{'0','','1'},'Fontsize',16);
xlabel('{\it x} (m)','Fontsize',16);
ylabel('{\it{\rho}_p / \rho_{p,max}}','Fontsize',16);

% Histogramme du nombre d'impact
subplot(2,1,2)
bar(xhist*1E6,nhist/max(nhist),'k'); % Axe des x en m (commodit)
axis([min(xhist*1E6) max(xhist*1E6) 0 1]);
set(gca,'XTick',-4:1:4,'XTickLabel',{'-4','','','','0','','','','4'},...
    'YTick',[0 0.5 1],'YTickLabel',{'0','','1'},'Fontsize',16);
xlabel('{\it x} (m)','Fontsize',16);
ylabel('{\it N / N_{max}}','Fontsize',16);

somme=sum(nhist);
display(['Nombre d''lectrons envoys : ',num2str(somme)]);

return